IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_MOVIMENTO_VENDAS_TIPO_VENDA_DEVOLUCAO]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_MOVIMENTO_VENDAS_TIPO_VENDA_DEVOLUCAO];
GO
--EXEC P_EST_MOVIMENTO_VENDAS_TIPO_VENDA_DEVOLUCAO
CREATE PROCEDURE P_EST_MOVIMENTO_VENDAS_TIPO_VENDA_DEVOLUCAO 
AS

set nocount on;
    declare @cd_chave int
		
    declare cChave 
    CURSOR FAST_FORWARD FOR
    SELECT 
	   v.CD_CTR_VENDAS 
    FROM
	   EST_MOVIMENTO_VENDAS v inner join EST_MOVIMENTO_VENDAS_PRODUTOS on
	   v.CD_CTR_VENDAS = EST_MOVIMENTO_VENDAS_PRODUTOS.CD_CTR_VENDAS
    where
	   v.TIPO_VENDA =3
	   AND (v.QTDE_VD > 0 or EST_MOVIMENTO_VENDAS_PRODUTOS.VLR_VD > 0)

	OPEN cChave
	FETCH NEXT FROM cChave INTO @cd_chave
	WHILE @@FETCH_STATUS = 0
		BEGIN
		  
		  PRINT 'Procesando ctr_vendas ' + CONVERT(VARCHAR, @cd_chave) + ' Time ' + convert(varchar, getdate(), 108);
		  begin try
		  
		  /*********************************************************************************************/
		  --EST_MOVIMENTO_VENDAS_PRODUTOS
		  /*********************************************************************************************/
		  UPDATE M
		  SET 
			  VLR_VD= VLR_VD										  *-1
			 , VLR_DESC_ITENS= VLR_DESC_ITENS						  *-1
			 , VLR_VD_LIQ= VLR_VD_LIQ								  *-1
			 , VLR_PMC= VLR_PMC										  *-1
			 , VLR_CUSTO_MD= VLR_CUSTO_MD							  *-1
			 , VLR_CUSTO_GER= VLR_CUSTO_GER							  *-1
			 , VLR_CUSTO= VLR_CUSTO									  *-1
			 , VLR_DESC_OFERTA= VLR_DESC_OFERTA						  *-1
			 , VLR_DESC_VERBA= VLR_DESC_VERBA						  *-1
			 , VLR_DESC_RATEIO= VLR_DESC_RATEIO						  *-1
			 , VLR_ICMS= VLR_ICMS									  *-1
			 , VLR_PIS_COFINS= VLR_PIS_COFINS						  *-1
			 , QTDE_ITENS= QTDE_ITENS								  *-1
			 , VLR_DINHEIRO= VLR_DINHEIRO							  *-1
			 , VLR_CHEQUES= VLR_CHEQUES								  *-1
			 , VLR_CHEQUES_VISTA= VLR_CHEQUES_VISTA					  *-1
			 , VLR_CHEQUES_PRAZO= VLR_CHEQUES_PRAZO					  *-1
			 , VLR_CARTAO= VLR_CARTAO								  *-1
			 , VLR_TICKETS= VLR_TICKETS								  *-1
			 , VLR_DUPLICATA= VLR_DUPLICATA							  *-1
			 , VLR_CONV= VLR_CONV									  *-1
			 , VLR_CHEQUE_TROCO= VLR_CHEQUE_TROCO					  *-1
			 , VLR_NCC= VLR_NCC										  *-1
			 , QTDE_VD= QTDE_VD										  *-1
			 , VLR_COMISSAO= VLR_COMISSAO							  *-1
			 , VLR_COMISSAO_FABRIC= VLR_COMISSAO_FABRIC				  *-1
			 , VLR_RECOMPOSICAO_MARGEM= VLR_RECOMPOSICAO_MARGEM		  *-1
			 , VLR_CONV_PBM= VLR_CONV_PBM							  *-1
			 , VLR_ISSQN= VLR_ISSQN									  *-1
		  FROM 
			 EST_MOVIMENTO_VENDAS_PRODUTOS m
		  where
			 m.CD_CTR_VENDAS =@cd_chave
			 and m.VLR_VD>0;

		  /*********************************************************************************************/ 
		  UPDATE M
		  SET  QTDE_VD= QTDE_VD *-1 
		  FROM 
			 EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS m
		  where
			 m.CD_CTR_VENDAS =@cd_chave
			 AND m.QTDE_VD < 0;

		  /*********************************************************************************************/
		  UPDATE M
		  SET  QTDE_VD= QTDE_VD *-1 
		  FROM 
			 EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_PRODUTO m
		  where
			 m.CD_CTR_VENDAS =@cd_chave
			 AND m.QTDE_VD > 0;
		  /*********************************************************************************************/
		  UPDATE M
		  SET  QTDE_VD= QTDE_VD *-1 
		  FROM 
			 EST_MOVIMENTO_VENDAS_TICKET_MEDIO_ORIGEM_VENDAS_VENDEDOR m
		  where
			 m.CD_CTR_VENDAS =@cd_chave
			 AND m.QTDE_VD > 0;

		  /*********************************************************************************************/
		  UPDATE M
		  SET  QTDE_VD= QTDE_VD *-1 
		  FROM 
			 EST_MOVIMENTO_VENDAS m
		  where
			 m.CD_CTR_VENDAS =@cd_chave
			 AND m.QTDE_VD > 0;

		  /*********************************************************************************************/
		  /*********************************************************************************************/ 

	   end try
	   begin catch
		  
		  DECLARE @ErrorMessage VARCHAR(4000)=ERROR_MESSAGE();  
				DECLARE @ErrorSeverity INT=ERROR_SEVERITY();  
				DECLARE @ErrorState INT=ERROR_STATE();  


				INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro )
				SELECT ERROR_NUMBER() AS numero,
					   @ErrorSeverity AS severidade,
					   @ErrorState AS estado,
					   ERROR_PROCEDURE() AS rotina,
					   ERROR_LINE() AS linha,
					   @ErrorMessage AS mensagem,
					   GETDATE() AS dtErro;
	   
				RAISERROR (@ErrorMessage, 
						 @ErrorSeverity,
						 @ErrorState );
				

	   end catch
		  FETCH NEXT FROM cChave INTO @cd_chave
	   END
    CLOSE cChave;
    DEALLOCATE cChave; 